/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.tile;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.blocks.CuttingBoardBlock;
import vectorwing.farmersdelight.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.registry.ModAdvancements;
import vectorwing.farmersdelight.registry.ModSounds;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.utils.TextUtils;
import vectorwing.farmersdelight.utils.tags.ForgeTags;

public class CuttingBoardTileEntity
extends TileEntity {
    private boolean isItemCarvingBoard;
    private ItemStackHandler itemHandler = this.createHandler();
    private LazyOptional<IItemHandler> handlerBoard = LazyOptional.of(() -> this.itemHandler);
    protected final IRecipeType<? extends CuttingBoardRecipe> recipeType;

    public CuttingBoardTileEntity(TileEntityType<?> tileEntityTypeIn, IRecipeType<? extends CuttingBoardRecipe> recipeTypeIn) {
        super(tileEntityTypeIn);
        this.recipeType = recipeTypeIn;
        this.isItemCarvingBoard = false;
    }

    public CuttingBoardTileEntity() {
        this((TileEntityType)ModTileEntityTypes.CUTTING_BOARD_TILE.get(), CuttingBoardRecipe.TYPE);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.isItemCarvingBoard = compound.func_74767_n("IsItemCarved");
        this.itemHandler.deserializeNBT(compound.func_74775_l("Inventory"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("Inventory", (INBT)this.itemHandler.serializeNBT());
        compound.func_74757_a("IsItemCarved", this.isItemCarvingBoard);
        return compound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    private void inventoryChanged() {
        super.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
    }

    public boolean processItemUsingTool(ItemStack tool, @Nullable PlayerEntity player) {
        List recipeList = this.field_145850_b.func_199532_z().func_215370_b(this.recipeType, (IInventory)new RecipeWrapper((IItemHandlerModifiable)this.itemHandler), this.field_145850_b);
        CuttingBoardRecipe recipe = recipeList.stream().filter(cuttingRecipe -> cuttingRecipe.getTool().test(tool)).findAny().orElse(null);
        if (player != null) {
            if (recipeList.isEmpty()) {
                player.func_146105_b((ITextComponent)TextUtils.getTranslation("block.cutting_board.invalid_item", new Object[0]), true);
            } else if (recipe == null) {
                player.func_146105_b((ITextComponent)TextUtils.getTranslation("block.cutting_board.invalid_tool", new Object[0]), true);
            }
        }
        if (recipe != null) {
            NonNullList<ItemStack> results = recipe.getResults();
            for (ItemStack result : results) {
                Direction direction = ((Direction)this.func_195044_w().func_177229_b((Property)CuttingBoardBlock.field_185512_D)).func_176735_f();
                ItemEntity entity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)direction.func_82601_c() * 0.2, (double)this.field_174879_c.func_177956_o() + 0.2, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)direction.func_82599_e() * 0.2, result.func_77946_l());
                entity.func_213293_j((double)((float)direction.func_82601_c() * 0.2f), 0.0, (double)((float)direction.func_82599_e() * 0.2f));
                this.field_145850_b.func_217376_c((Entity)entity);
            }
            if (player != null) {
                tool.func_222118_a(1, (LivingEntity)player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
            } else if (tool.func_96631_a(1, this.field_145850_b.field_73012_v, null)) {
                tool.func_190920_e(0);
            }
            this.playProcessingSound(recipe.getSoundEventID(), tool.func_77973_b(), this.getStoredItem().func_77973_b());
            this.removeItem();
            this.inventoryChanged();
            if (player instanceof ServerPlayerEntity) {
                ModAdvancements.CUTTING_BOARD.trigger((ServerPlayerEntity)player);
            }
            return true;
        }
        return false;
    }

    public void playProcessingSound(String soundEventID, Item tool, Item boardItem) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundEventID));
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else if (tool.func_206844_a((ITag)Tags.Items.SHEARS)) {
            this.playSound(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        } else if (tool.func_206844_a(ForgeTags.TOOLS_KNIVES)) {
            this.playSound((SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), 0.8f, 1.0f);
        } else if (boardItem instanceof BlockItem) {
            Block block = ((BlockItem)boardItem).func_179223_d();
            SoundType soundType = block.func_176223_P().func_215695_r();
            this.playSound(soundType.func_185845_c(), 1.0f, 0.8f);
        } else {
            this.playSound(SoundEvents.field_187881_gQ, 1.0f, 0.8f);
        }
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        this.field_145850_b.func_184148_a(null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), sound, SoundCategory.BLOCKS, volume, pitch);
    }

    public boolean carveToolOnBoard(ItemStack tool) {
        if (this.addItem(tool)) {
            this.isItemCarvingBoard = true;
            return true;
        }
        return false;
    }

    public boolean getIsItemCarvingBoard() {
        return this.isItemCarvingBoard;
    }

    public IItemHandler getInventory() {
        return this.itemHandler;
    }

    public boolean isEmpty() {
        return this.itemHandler.getStackInSlot(0).func_190926_b();
    }

    public ItemStack getStoredItem() {
        return this.itemHandler.getStackInSlot(0);
    }

    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.func_190926_b()) {
            this.itemHandler.setStackInSlot(0, itemStack.func_77979_a(1));
            this.isItemCarvingBoard = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            this.isItemCarvingBoard = false;
            ItemStack item = this.getStoredItem().func_77979_a(1);
            this.inventoryChanged();
            return item;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                CuttingBoardTileEntity.this.inventoryChanged();
            }
        };
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return this.handlerBoard.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.handlerBoard.invalidate();
    }
}

